﻿//+------------------------------------------------------------------+
//|                     BullishBeauty Forex Trading Bot              |
//|   Simpele MA-cross strategie, gelicentieerd en XAUUSDs-focused   |
//+------------------------------------------------------------------+
#property strict
#property version   "1.10"
#property copyright "BullishBeauty"
#property link      "https://jouw-website-hier.nl"

#include <Trade\Trade.mqh>

//--- Licentie instellingen
input long    Licensed_Account   = 0;            // MT5-accountnummer waarvoor de bot is geactiveerd
input string  License_Expiry     = "2030.12.31"; // Licentie vervaldatum (JJJJ.MM.DD)

//--- Strategie instellingen
input int      FastMA_Period     = 12;           // Snelle MA-periode
input int      SlowMA_Period     = 26;           // Langzame MA-periode
input double   LotSize           = 0.01;         // Lotgrootte
input int      StopLossPoints    = 2500;         // SL in punten
input int      TakeProfitPoints  = 5000;         // TP in punten
input int      MagicNumber       = 888111;       // Uniek Magic Number

//--- Globale variabelen
int            handleFastMA;
int            handleSlowMA;
CTrade         trade;

//+------------------------------------------------------------------+
//| Licentiecontrole                                                 |
//+------------------------------------------------------------------+
bool CheckLicense()
{
   long account = AccountInfoInteger(ACCOUNT_LOGIN);
   datetime today = TimeCurrent();

   // Accountcontrole
   if(Licensed_Account != 0 && account != Licensed_Account)
   {
      Print("BullishBeauty License Error: Dit account (", account,
            ") is niet geautoriseerd. Verwacht: ", Licensed_Account);
      return(false);
   }

   // Vervaldatum controleren
   datetime expiry = StringToTime(License_Expiry);

   if(expiry == 0)
   {
      Print("BullishBeauty License Error: Ongeldige datum in License_Expiry. Gebruik formaat JJJJ.MM.DD");
      return(false);
   }

   if(today > expiry)
   {
      Print("BullishBeauty License Error: Licentie verlopen op ", License_Expiry);
      return(false);
   }

   return(true);
}

//+------------------------------------------------------------------+
//| Initialisatie                                                    |
//+------------------------------------------------------------------+
int OnInit()
{
   // Optioneel: lock op XAUUSDs
   if(_Symbol != "XAUUSDs")
   {
      Print("BullishBeauty Info: Deze bot is bedoeld voor XAUUSDs. Huidig symbool: ", _Symbol);
      // Wil je hard locken? Haal dan de comment weg:
      // return(INIT_FAILED);
   }

   if(!CheckLicense())
      return(INIT_FAILED);

   trade.SetExpertMagicNumber(MagicNumber);

   handleFastMA = iMA(_Symbol, _Period, FastMA_Period, 0, MODE_SMA, PRICE_CLOSE);
   handleSlowMA = iMA(_Symbol, _Period, SlowMA_Period, 0, MODE_SMA, PRICE_CLOSE);

   if(handleFastMA == INVALID_HANDLE || handleSlowMA == INVALID_HANDLE)
   {
      Print("BullishBeauty Error: Fout bij laden van MA-indicators voor ", _Symbol);
      return(INIT_FAILED);
   }

   Print("BullishBeauty Forex Trading Bot succesvol geïnitialiseerd op account ",
         AccountInfoInteger(ACCOUNT_LOGIN));
   return(INIT_SUCCEEDED);
}

//+------------------------------------------------------------------+
//| De kern van de bot                                               |
//+------------------------------------------------------------------+
void OnTick()
{
   if(!CheckLicense())
      return;

   double maFast[], maSlow[];
   ArraySetAsSeries(maFast, true);
   ArraySetAsSeries(maSlow, true);

   if(CopyBuffer(handleFastMA, 0, 0, 3, maFast) < 3) return;
   if(CopyBuffer(handleSlowMA, 0, 0, 3, maSlow) < 3) return;

   bool hasPosition = false;
   for(int i = PositionsTotal() - 1; i >= 0; i--)
   {
      ulong ticket = PositionGetTicket(i);
      if(PositionSelectByTicket(ticket))
      {
         if(PositionGetString(POSITION_SYMBOL) == _Symbol &&
            PositionGetInteger(POSITION_MAGIC) == MagicNumber)
         {
            hasPosition = true;
            break;
         }
      }
   }

   double ask   = SymbolInfoDouble(_Symbol, SYMBOL_ASK);
   double bid   = SymbolInfoDouble(_Symbol, SYMBOL_BID);
   double point = SymbolInfoDouble(_Symbol, SYMBOL_POINT);

   //--- KOOP SIGNAAL
   if(maFast[1] > maSlow[1] && maFast[2] <= maSlow[2])
   {
      if(!hasPosition)
      {
         double sl = NormalizeDouble(ask - (StopLossPoints * point), _Digits);
         double tp = NormalizeDouble(ask + (TakeProfitPoints * point), _Digits);

         if(trade.Buy(LotSize, _Symbol, ask, sl, tp, "BullishBeauty Buy"))
            Print("BullishBeauty: Buy order geplaatst op ", _Symbol);
         else
            Print("BullishBeauty Error: Buy order mislukt. Foutcode: ", GetLastError());
      }
   }

   //--- VERKOOP SIGNAAL
   if(maFast[1] < maSlow[1] && maFast[2] >= maSlow[2])
   {
      if(!hasPosition)
      {
         double sl = NormalizeDouble(bid + (StopLossPoints * point), _Digits);
         double tp = NormalizeDouble(bid - (TakeProfitPoints * point), _Digits);

         if(trade.Sell(LotSize, _Symbol, bid, sl, tp, "BullishBeauty Sell"))
            Print("BullishBeauty: Sell order geplaatst op ", _Symbol);
         else
            Print("BullishBeauty Error: Sell order mislukt. Foutcode: ", GetLastError());
      }
   }
}

